/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import simpletree.view.tools.IconWithArrow;

public class JDropDownMenuButton
extends JButton {
    private boolean mouseInButton = false;
    private boolean mouseInArrowArea = false;
    private Map<String, Icon> regIcons = new HashMap<String, Icon>(5);
    private Map<String, Icon> arrowIcons = new HashMap<String, Icon>(5);
    private static final String ICON_NORMAL = "normal";
    private static final String ICON_PRESSED = "pressed";
    private static final String ICON_ROLLOVER = "rollover";
    private static final String ICON_ROLLOVER_SELECTED = "rolloverSelected";
    private static final String ICON_SELECTED = "selected";
    private static final String ICON_DISABLED = "disabled";
    private static final String ICON_DISABLED_SELECTED = "disabledSelected";
    private static final String ICON_ROLLOVER_LINE = "rolloverLine";
    private static final String ICON_ROLLOVER_SELECTED_LINE = "rolloverSelectedLine";
    private static final String PROP_DROP_DOWN_MENU = "dropDownMenu";
    private PopupMenuListener menuListener;

    public JDropDownMenuButton() {
        this((Icon)null, (JPopupMenu)null);
    }

    public JDropDownMenuButton(Icon icon, JPopupMenu popup) {
        this.putClientProperty(PROP_DROP_DOWN_MENU, popup);
        this.setIcon(icon);
        this.resetIcons();
        this.addPropertyChangeListener(PROP_DROP_DOWN_MENU, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                JDropDownMenuButton.this.resetIcons();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (null != JDropDownMenuButton.this.getPopupMenu()) {
                    JDropDownMenuButton.this.mouseInArrowArea = JDropDownMenuButton.this.isInArrowArea(e.getPoint());
                    JDropDownMenuButton.this.updateRollover(JDropDownMenuButton.this._getRolloverIcon(), JDropDownMenuButton.this._getRolloverSelectedIcon());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private boolean popupMenuOperation = false;

            @Override
            public void mousePressed(MouseEvent e) {
                this.popupMenuOperation = false;
                JPopupMenu menu = JDropDownMenuButton.this.getPopupMenu();
                if (menu != null && JDropDownMenuButton.this.getModel() instanceof Model) {
                    Model model = (Model)JDropDownMenuButton.this.getModel();
                    if (!model._isPressed()) {
                        if (JDropDownMenuButton.this.isInArrowArea(e.getPoint()) && menu.getComponentCount() > 0) {
                            model._press();
                            menu.addPopupMenuListener(JDropDownMenuButton.this.getMenuListener());
                            menu.show(JDropDownMenuButton.this, 0, JDropDownMenuButton.this.getHeight());
                            this.popupMenuOperation = true;
                        }
                    } else {
                        model._release();
                        menu.removePopupMenuListener(JDropDownMenuButton.this.getMenuListener());
                        this.popupMenuOperation = true;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.popupMenuOperation) {
                    this.popupMenuOperation = false;
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JDropDownMenuButton.this.mouseInButton = true;
                if (JDropDownMenuButton.this.hasPopupMenu()) {
                    JDropDownMenuButton.this.mouseInArrowArea = JDropDownMenuButton.this.isInArrowArea(e.getPoint());
                    JDropDownMenuButton.this.updateRollover(JDropDownMenuButton.this._getRolloverIcon(), JDropDownMenuButton.this._getRolloverSelectedIcon());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JDropDownMenuButton.this.mouseInButton = false;
                JDropDownMenuButton.this.mouseInArrowArea = false;
                if (JDropDownMenuButton.this.hasPopupMenu()) {
                    JDropDownMenuButton.this.updateRollover(JDropDownMenuButton.this._getRolloverIcon(), JDropDownMenuButton.this._getRolloverSelectedIcon());
                }
            }
        });
        this.setModel(new Model());
    }

    private PopupMenuListener getMenuListener() {
        if (null == this.menuListener) {
            this.menuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    JPopupMenu menu;
                    if (JDropDownMenuButton.this.getModel() instanceof Model) {
                        ((Model)JDropDownMenuButton.this.getModel())._release();
                    }
                    if (null != (menu = JDropDownMenuButton.this.getPopupMenu())) {
                        menu.removePopupMenuListener(this);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
        }
        return this.menuListener;
    }

    private void updateRollover(Icon rollover, Icon rolloverSelected) {
        super.setRolloverIcon(rollover);
        super.setRolloverSelectedIcon(rolloverSelected);
    }

    private void resetIcons() {
        Icon icon = this.regIcons.get(ICON_NORMAL);
        if (null != icon) {
            this.setIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_PRESSED))) {
            this.setPressedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_ROLLOVER))) {
            this.setRolloverIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_ROLLOVER_SELECTED))) {
            this.setRolloverSelectedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_SELECTED))) {
            this.setSelectedIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_DISABLED))) {
            this.setDisabledIcon(icon);
        }
        if (null != (icon = this.regIcons.get(ICON_DISABLED_SELECTED))) {
            this.setDisabledSelectedIcon(icon);
        }
    }

    private Icon _getRolloverIcon() {
        Icon icon = this.arrowIcons.get(this.mouseInArrowArea ? ICON_ROLLOVER : ICON_ROLLOVER_LINE);
        if (null == icon) {
            Icon orig = this.regIcons.get(ICON_ROLLOVER);
            if (null == orig) {
                orig = this.regIcons.get(ICON_NORMAL);
            }
            icon = new IconWithArrow(orig, !this.mouseInArrowArea);
            this.arrowIcons.put(this.mouseInArrowArea ? ICON_ROLLOVER : ICON_ROLLOVER_LINE, icon);
        }
        return icon;
    }

    private Icon _getRolloverSelectedIcon() {
        Icon icon = this.arrowIcons.get(this.mouseInArrowArea ? ICON_ROLLOVER_SELECTED : ICON_ROLLOVER_SELECTED_LINE);
        if (icon == null) {
            Icon orig = this.regIcons.get(ICON_ROLLOVER_SELECTED);
            if (orig == null) {
                orig = this.regIcons.get(ICON_ROLLOVER);
            }
            if (orig == null) {
                orig = this.regIcons.get(ICON_NORMAL);
            }
            icon = new IconWithArrow(orig, !this.mouseInArrowArea);
            this.arrowIcons.put(this.mouseInArrowArea ? ICON_ROLLOVER_SELECTED : ICON_ROLLOVER_SELECTED_LINE, icon);
        }
        return icon;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.putClientProperty(PROP_DROP_DOWN_MENU, popupMenu);
    }

    JPopupMenu getPopupMenu() {
        Object menu = this.getClientProperty(PROP_DROP_DOWN_MENU);
        if (menu instanceof JPopupMenu) {
            return (JPopupMenu)menu;
        }
        return null;
    }

    boolean hasPopupMenu() {
        return null != this.getPopupMenu();
    }

    private boolean isInArrowArea(Point p) {
        return true;
    }

    @Override
    public void setIcon(Icon icon) {
        Icon arrow = this.updateIcons(icon, ICON_NORMAL);
        this.arrowIcons.remove(ICON_ROLLOVER_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED);
        super.setIcon(this.hasPopupMenu() ? arrow : icon);
    }

    private Icon updateIcons(Icon orig, String iconType) {
        ImageIcon arrow = null;
        if (null == orig) {
            this.regIcons.remove(iconType);
            this.arrowIcons.remove(iconType);
        } else {
            this.regIcons.put(iconType, orig);
            arrow = new ImageIcon(IconWithArrow.icon2Image(new IconWithArrow(orig, false)));
            this.arrowIcons.put(iconType, arrow);
        }
        return arrow;
    }

    @Override
    public void setPressedIcon(Icon icon) {
        Icon arrow = this.updateIcons(icon, ICON_PRESSED);
        super.setPressedIcon(this.hasPopupMenu() ? arrow : icon);
    }

    @Override
    public void setSelectedIcon(Icon icon) {
        Icon arrow = this.updateIcons(icon, ICON_SELECTED);
        super.setSelectedIcon(this.hasPopupMenu() ? arrow : icon);
    }

    @Override
    public void setRolloverIcon(Icon icon) {
        Icon arrow = this.updateIcons(icon, ICON_ROLLOVER);
        this.arrowIcons.remove(ICON_ROLLOVER_LINE);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        super.setRolloverIcon(this.hasPopupMenu() ? arrow : icon);
    }

    @Override
    public void setRolloverSelectedIcon(Icon icon) {
        Icon arrow = this.updateIcons(icon, ICON_ROLLOVER_SELECTED);
        this.arrowIcons.remove(ICON_ROLLOVER_SELECTED_LINE);
        super.setRolloverSelectedIcon(this.hasPopupMenu() ? arrow : icon);
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        Icon arrow = this.updateIcons(icon, ICON_DISABLED);
        super.setDisabledIcon(this.hasPopupMenu() ? arrow : icon);
    }

    @Override
    public void setDisabledSelectedIcon(Icon icon) {
        Icon arrow = this.updateIcons(icon, ICON_DISABLED_SELECTED);
        super.setDisabledSelectedIcon(this.hasPopupMenu() ? arrow : icon);
    }

    @Override
    public void setText(String text) {
        Logger.getLogger(JDropDownMenuButton.class.getName()).log(Level.FINER, "DropDownButton cannot display text.");
    }

    @Override
    public String getText() {
        return null;
    }

    private class Model
    extends DefaultButtonModel {
        private boolean _pressed = false;

        private Model() {
        }

        @Override
        public void setPressed(boolean b) {
            if (JDropDownMenuButton.this.mouseInArrowArea || this._pressed) {
                return;
            }
            super.setPressed(b);
        }

        public void _press() {
            if (this.isPressed() || !this.isEnabled()) {
                return;
            }
            this.stateMask |= 5;
            this.fireStateChanged();
            this._pressed = true;
        }

        public void _release() {
            this._pressed = false;
            JDropDownMenuButton.this.mouseInArrowArea = false;
            this.setArmed(false);
            this.setPressed(false);
            this.setRollover(false);
            this.setSelected(false);
        }

        public boolean _isPressed() {
            return this._pressed;
        }

        @Override
        protected void fireStateChanged() {
            if (this._pressed) {
                return;
            }
            super.fireStateChanged();
        }

        @Override
        public void setArmed(boolean b) {
            if (this._pressed) {
                return;
            }
            super.setArmed(b);
        }

        @Override
        public void setEnabled(boolean b) {
            if (this._pressed) {
                return;
            }
            super.setEnabled(b);
        }

        @Override
        public void setSelected(boolean b) {
            if (this._pressed) {
                return;
            }
            super.setSelected(b);
        }

        @Override
        public void setRollover(boolean b) {
            if (this._pressed) {
                return;
            }
            super.setRollover(b);
        }
    }
}

