/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class LineIterator
implements Iterator<Point2D> {
    static final double DEFAULT_PRECISION = 1.0;
    final Line2D line;
    final double precision;
    final double sx;
    final double sy;
    final double dx;
    final double dy;
    double x;
    double y;
    double error;

    public LineIterator(Line2D line, double precision) {
        this.line = line;
        this.precision = precision;
        this.sx = line.getX1() < line.getX2() ? precision : -1.0 * precision;
        this.sy = line.getY1() < line.getY2() ? precision : -1.0 * precision;
        this.dx = Math.abs(line.getX2() - line.getX1());
        this.dy = Math.abs(line.getY2() - line.getY1());
        this.error = this.dx - this.dy;
        this.y = line.getY1();
        this.x = line.getX1();
    }

    public LineIterator(Line2D line) {
        this(line, 1.0);
    }

    @Override
    public boolean hasNext() {
        return Math.abs(this.x - this.line.getX2()) > 0.9 || Math.abs(this.y - this.line.getY2()) > 0.9;
    }

    @Override
    public Point2D next() {
        Point2D.Double ret = new Point2D.Double(this.x, this.y);
        double e2 = 2.0 * this.error;
        if (e2 > -this.dy) {
            this.error -= this.dy;
            this.x += this.sx;
        }
        if (e2 < this.dx) {
            this.error += this.dx;
            this.y += this.sy;
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new AssertionError();
    }
}

