/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools.silhouette;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;

public class DataSilhouetteCoefficient {
    public float average(float[] silhouette) throws IOException {
        float s = 0.0f;
        for (int i = 0; i < silhouette.length; ++i) {
            s += silhouette[i];
        }
        return s / (float)silhouette.length;
    }

    public boolean canCompute(AbstractMatrix matrix) {
        float[] cdata = matrix.getClassData();
        ArrayList<Float> cdata_index = new ArrayList<Float>();
        for (int i = 0; i < cdata.length; ++i) {
            if (cdata_index.contains(Float.valueOf(cdata[i]))) continue;
            cdata_index.add(Float.valueOf(cdata[i]));
        }
        return cdata_index.size() > 1;
    }

    public float[] execute(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        float[] cdata = matrix.getClassData();
        ArrayList<Float> cdata_index = new ArrayList<Float>();
        for (int i = 0; i < cdata.length; ++i) {
            if (cdata_index.contains(Float.valueOf(cdata[i]))) continue;
            cdata_index.add(Float.valueOf(cdata[i]));
        }
        if (cdata_index.size() <= 1) {
            throw new IOException("Only one cluster found. It is not possible to calculate the Silhouette coefficient.");
        }
        ArrayList clusters = new ArrayList();
        for (int i = 0; i < cdata_index.size(); ++i) {
            clusters.add(new ArrayList());
        }
        int[] cluster_id = new int[cdata.length];
        for (int i = 0; i < cdata.length; ++i) {
            int index = cdata_index.indexOf(Float.valueOf(cdata[i]));
            ((ArrayList)clusters.get(index)).add(i);
            cluster_id[i] = index;
        }
        float[] s = new float[cdata.length];
        for (int i = 0; i < s.length; ++i) {
            if (((ArrayList)clusters.get(cluster_id[i])).size() > 1) {
                float a = this.average(matrix, (ArrayList)clusters.get(cluster_id[i]), matrix.getRow(i), diss);
                float b = Float.POSITIVE_INFINITY;
                for (int j = 0; j < clusters.size(); ++j) {
                    if (j == cluster_id[i]) continue;
                    b = Math.min(b, this.average(matrix, (ArrayList)clusters.get(j), matrix.getRow(i), diss));
                }
                if ((double)b != 0.0 && (double)a != 0.0) {
                    s[i] = (b - a) / Math.max(a, b);
                    continue;
                }
                s[i] = 0.0f;
                continue;
            }
            s[i] = 0.0f;
        }
        return s;
    }

    public float[] execute(DistanceMatrix dmat) throws IOException {
        float[] cdata = dmat.getClassData();
        ArrayList<Float> cdata_index = new ArrayList<Float>();
        for (int i = 0; i < cdata.length; ++i) {
            if (cdata_index.contains(Float.valueOf(cdata[i]))) continue;
            cdata_index.add(Float.valueOf(cdata[i]));
        }
        if (cdata_index.size() <= 1) {
            throw new IOException("Only one cluster found. It is not possible to calculate the Silhouette coefficient.");
        }
        ArrayList clusters = new ArrayList();
        for (int i = 0; i < cdata_index.size(); ++i) {
            clusters.add(new ArrayList());
        }
        int[] cluster_id = new int[cdata.length];
        for (int i = 0; i < cdata.length; ++i) {
            int index = cdata_index.indexOf(Float.valueOf(cdata[i]));
            ((ArrayList)clusters.get(index)).add(i);
            cluster_id[i] = index;
        }
        float[] s = new float[cdata.length];
        for (int i = 0; i < s.length; ++i) {
            if (((ArrayList)clusters.get(cluster_id[i])).size() > 1) {
                float a = this.average(dmat, (ArrayList)clusters.get(cluster_id[i]), i);
                float b = Float.POSITIVE_INFINITY;
                for (int j = 0; j < clusters.size(); ++j) {
                    if (j == cluster_id[i]) continue;
                    b = Math.min(b, this.average(dmat, (ArrayList)clusters.get(j), i));
                }
                s[i] = (b - a) / Math.max(a, b);
                continue;
            }
            s[i] = 0.0f;
        }
        return s;
    }

    private float average(AbstractMatrix matrix, ArrayList<Integer> cluster, AbstractVector vector, AbstractDissimilarity diss) {
        float a = 0.0f;
        for (int i = 0; i < cluster.size(); ++i) {
            a += diss.calculate(vector, matrix.getRow(cluster.get(i)));
        }
        return a / (float)cluster.size();
    }

    private float average(DistanceMatrix dmat, ArrayList<Integer> cluster, int id) {
        float a = 0.0f;
        for (int i = 0; i < cluster.size(); ++i) {
            a += dmat.getDistance(id, cluster.get(i));
        }
        return a / (float)cluster.size();
    }
}

