/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools.silhouette;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.TreeDistanceCalculator;
import simpletree.view.tools.silhouette.SimpleTreeModelSilhouetteParamView;
import simpletree.view.tools.silhouette.SimpleTreeSilhouetteCoefficientConsole;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Data Analysis.Silhouette", name="Simple Tree Model Silhouette Coefficient", description="Display the silhouette coefficient of a clustered dataset.")
public class SimpleTreeModelSilhouetteComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String title = "";
    private transient SimpleTreeModel model;
    private transient SimpleTreeModelSilhouetteParamView paramview;
    private boolean useWeight;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;
    private float averageSilhouette;
    private boolean showWindowResponse = true;
    private TreeDistanceCalculator t = new TreeDistanceCalculator();

    public void execute() throws IOException {
        float[] silhouette = null;
        if (this.model != null) {
            int i;
            Scalar scalar = this.model.getScalarByName("cdata");
            if (scalar == null && this.model.getScalars() != null && !this.model.getScalars().isEmpty()) {
                scalar = this.model.getScalars().get(0);
            }
            ArrayList<Edge> edges = null;
            if (this.model.getSelectedConnectivity() != null) {
                edges = this.model.getSelectedConnectivity().getEdges();
            } else if (this.model.getConnectivities() != null && this.model.getConnectivities().size() > 1) {
                edges = this.model.getConnectivities().get(1).getEdges();
            }
            if (edges == null) {
                return;
            }
            float[] cdata = new float[this.model.getValidInstances().size()];
            int[] ids = new int[this.model.getValidInstances().size()];
            for (i = 0; i < this.model.getValidInstances().size(); ++i) {
                cdata[i] = ((SimpleTreeInstance)this.model.getValidInstances().get(i)).getScalarValue(scalar);
                ids[i] = this.model.getValidInstances().get(i).getId();
            }
            if (this.matrix != null) {
                for (i = 0; i < this.model.getValidInstances().size(); ++i) {
                    AbstractVector row = this.matrix.getRow(this.matrix.getIds().indexOf(this.model.getValidInstances().get(i).getId()));
                    cdata[i] = row.getKlass();
                }
            } else if (this.dmat != null) {
                for (i = 0; i < this.model.getValidInstances().size(); ++i) {
                    cdata[i] = this.dmat.getClassData()[this.dmat.getIds().indexOf(this.model.getValidInstances().get(i).getId())];
                }
            }
            silhouette = this.getSilhouetteValues(edges, ids, cdata);
            String result = "";
            if (silhouette != null) {
                float average = 0.0f;
                for (int i2 = 0; i2 < silhouette.length; ++i2) {
                    average += silhouette[i2];
                }
                this.averageSilhouette = average /= (float)silhouette.length;
                result = "Silhouette coefficient: " + average + "\r\n";
                result = result + "---\r\n\n";
            } else {
                result = result + "Error generating Silhouette coefficient.";
            }
            System.out.println(result);
            if (this.showWindowResponse) {
                SimpleTreeSilhouetteCoefficientConsole.getInstance(null).display(this.title, result);
            }
        }
    }

    public void input(@Param(name="Simple Tree Model") SimpleTreeModel model) {
        this.model = model;
    }

    public void input(@Param(name="Original Distance Matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public void input(@Param(name="Original Data Matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new SimpleTreeModelSilhouetteParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
    }

    public float[] getSilhouetteValues(ArrayList<Edge> edges, int[] ids, float[] cdata) throws IOException {
        ArrayList<Float> cdata_index = new ArrayList<Float>();
        for (int i = 0; i < cdata.length; ++i) {
            if (cdata_index.contains(Float.valueOf(cdata[i]))) continue;
            cdata_index.add(Float.valueOf(cdata[i]));
        }
        if (cdata_index.size() <= 1) {
            throw new IOException("Only one cluster found. It is not possible to calculate the Silhouette coefficient.");
        }
        ArrayList clusters = new ArrayList();
        for (int i = 0; i < cdata_index.size(); ++i) {
            clusters.add(new ArrayList());
        }
        System.out.println("Storing the clusters instances belongs to...");
        int[] cluster_id = new int[cdata.length];
        for (int i = 0; i < cdata.length; ++i) {
            int index = cdata_index.indexOf(Float.valueOf(cdata[i]));
            ((ArrayList)clusters.get(index)).add(i);
            cluster_id[i] = index;
        }
        float[] s = new float[cdata.length];
        System.out.println("Calculating individual silhuette values...");
        for (int i = 0; i < s.length; ++i) {
            if (i % (int)((double)s.length * 0.05) == 0) {
                System.out.println("-- Processing instance " + i);
            }
            if (((ArrayList)clusters.get(cluster_id[i])).size() > 1) {
                float a = this.average(edges, ids, (ArrayList)clusters.get(cluster_id[i]), i);
                float b = Float.POSITIVE_INFINITY;
                for (int j = 0; j < clusters.size(); ++j) {
                    if (j == cluster_id[i]) continue;
                    b = Math.min(b, this.average(edges, ids, (ArrayList)clusters.get(j), i));
                }
                s[i] = (b - a) / Math.max(a, b);
                continue;
            }
            s[i] = 0.0f;
        }
        return s;
    }

    private float average(ArrayList<Edge> edges, int[] ids, ArrayList<Integer> cluster, int id) {
        float a = 0.0f;
        for (int i = 0; i < cluster.size(); ++i) {
            float dist = this.t.getDistance(edges, ids[id], ids[cluster.get(i)], this.useWeight);
            a += dist;
        }
        return a / (float)cluster.size();
    }

    public float average(float[] silhouette) throws IOException {
        float s = 0.0f;
        for (int i = 0; i < silhouette.length; ++i) {
            s += silhouette[i];
        }
        return s / (float)silhouette.length;
    }

    public boolean isUseWeight() {
        return this.useWeight;
    }

    public void setUseWeight(boolean useWeigth) {
        this.useWeight = useWeigth;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public float getAverageSilhouette() {
        return this.averageSilhouette;
    }

    public void setAverageSilhouette(float averageSilhouette) {
        this.averageSilhouette = averageSilhouette;
    }

    public void setShowWindowResponse(boolean value) {
        this.showWindowResponse = value;
    }

    public boolean getShowWindowResponse() {
        return this.showWindowResponse;
    }
}

