/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools.silhouette;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.model.Edge;
import simpletree.util.TreeDistanceCalculator;
import simpletree.view.tools.silhouette.DataSilhouetteCoefficient;

public class SimpleTreeSilhouetteCoefficient
extends DataSilhouetteCoefficient {
    public float[] execute(ArrayList<Edge> edges, int[] ids, float[] cdata, boolean useEdgeWeight) throws IOException {
        ArrayList<Float> cdata_index = new ArrayList<Float>();
        for (int i = 0; i < cdata.length; ++i) {
            if (cdata_index.contains(Float.valueOf(cdata[i]))) continue;
            cdata_index.add(Float.valueOf(cdata[i]));
        }
        if (cdata_index.size() <= 1) {
            throw new IOException("Only one cluster found. It is not possible to calculate the Silhouette coefficient.");
        }
        ArrayList clusters = new ArrayList();
        for (int i = 0; i < cdata_index.size(); ++i) {
            clusters.add(new ArrayList());
        }
        int[] cluster_id = new int[cdata.length];
        for (int i = 0; i < cdata.length; ++i) {
            int index = cdata_index.indexOf(Float.valueOf(cdata[i]));
            ((ArrayList)clusters.get(index)).add(i);
            cluster_id[i] = index;
        }
        float[] s = new float[cdata.length];
        for (int i = 0; i < s.length; ++i) {
            if (((ArrayList)clusters.get(cluster_id[i])).size() > 1) {
                float a = this.average(edges, ids, (ArrayList)clusters.get(cluster_id[i]), i, useEdgeWeight);
                float b = Float.POSITIVE_INFINITY;
                for (int j = 0; j < clusters.size(); ++j) {
                    if (j == cluster_id[i]) continue;
                    b = Math.min(b, this.average(edges, ids, (ArrayList)clusters.get(j), i, useEdgeWeight));
                }
                s[i] = (b - a) / Math.max(a, b);
                continue;
            }
            s[i] = 0.0f;
        }
        return s;
    }

    private float average(ArrayList<Edge> edges, int[] ids, ArrayList<Integer> cluster, int id, boolean useEdgeWeights) {
        float a = 0.0f;
        TreeDistanceCalculator t = new TreeDistanceCalculator();
        for (int i = 0; i < cluster.size(); ++i) {
            a += t.getDistance(edges, ids[id], ids[cluster.get(i)], useEdgeWeights);
        }
        return a / (float)cluster.size();
    }
}

