/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools.silhouette;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.AbstractInstance;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.AbstractFilter;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.DMATFilter;
import simpletree.view.JFrameModelViewer;
import simpletree.view.tools.silhouette.SimpleTreeSilhouetteCoefficient;
import simpletree.view.tools.silhouette.SimpleTreeSilhouetteCoefficientConsole;

public class SimpleTreeSilhouetteCoefficientView
extends JDialog {
    private SimpleTreeModel model;
    private int choice;
    private Scalar scalar;
    JFrameModelViewer parent;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JPanel chooseDistanceTypePanel2;
    private JButton closeButton;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JButton generateButton;
    private JPanel jPanel1;
    private JCheckBox originalCheckBox;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private JCheckBox projectedCheckBox;
    private JCheckBox scalarCheckBox;
    private JPanel scalarPanel;
    private JPanel sourcePanel;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JTextField titleTextField;
    private JCheckBox useWeightsCheckBox;

    private SimpleTreeSilhouetteCoefficientView(JFrameModelViewer parent) {
        super(parent);
        this.parent = parent;
        this.initComponents();
        this.setModal(true);
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.distanceComboBox.addItem(disstype);
        }
        this.distanceComboBox.setSelectedItem((Object)DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        if (this.originalCheckBox.isSelected()) {
            this.sourcePanel.setVisible(true);
        } else {
            this.sourcePanel.setVisible(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.dataPanel = new JPanel();
        this.chooseDistanceTypePanel2 = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.scalarPanel = new JPanel();
        this.scalarCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.originalCheckBox = new JCheckBox();
        this.projectedCheckBox = new JCheckBox();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.useWeightsCheckBox = new JCheckBox();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.buttonPanel = new JPanel();
        this.generateButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Calculate the Silhouette");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.chooseDistanceTypePanel2.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel2.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.chooseDistanceTypePanel2, gridBagConstraints);
        this.scalarPanel.setBorder(BorderFactory.createTitledBorder("Scalar"));
        this.scalarCheckBox.setSelected(true);
        this.scalarCheckBox.setText("Create scalars");
        this.scalarPanel.add(this.scalarCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.scalarPanel, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Source"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.originalCheckBox.setText("Original Data");
        this.originalCheckBox.setHorizontalAlignment(0);
        this.originalCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSilhouetteCoefficientView.this.originalCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.originalCheckBox, gridBagConstraints);
        this.projectedCheckBox.setText("Graph Data");
        this.projectedCheckBox.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.projectedCheckBox, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSilhouetteCoefficientView.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.buttonGroup1.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSilhouetteCoefficientView.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSilhouetteCoefficientView.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSilhouetteCoefficientView.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.sourcePanel, gridBagConstraints);
        this.useWeightsCheckBox.setText("Use Edges Weights");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.useWeightsCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.titlePanel.setBorder(BorderFactory.createTitledBorder(""));
        this.titleLabel.setText("Title (Optional) : ");
        this.titlePanel.add(this.titleLabel);
        this.titleTextField.setColumns(15);
        this.titlePanel.add(this.titleTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.titlePanel, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSilhouetteCoefficientView.this.generateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.generateButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSilhouetteCoefficientView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.model != null) {
                AbstractDissimilarity diss = DissimilarityFactory.getInstance((DissimilarityFactory.DissimilarityType)((Object)this.distanceComboBox.getSelectedItem()));
                SimpleTreeSilhouetteCoefficient sc = new SimpleTreeSilhouetteCoefficient();
                String result = "";
                boolean wrote = false;
                if (this.originalCheckBox.isSelected()) {
                    AbstractMatrix originalMatrix = null;
                    DistanceMatrix originalDmat = null;
                    float[] silhouette = null;
                    if (this.choice == 0) {
                        if (this.pointsTextField.getText().trim().isEmpty()) {
                            JOptionPane.showMessageDialog(this, "A source data must be informed!", "Error", 0);
                        } else {
                            originalMatrix = MatrixFactory.getInstance(this.pointsTextField.getText());
                            if (originalMatrix != null) {
                                silhouette = sc.execute(originalMatrix, diss);
                            }
                        }
                    } else if (this.choice == 1) {
                        if (this.distanceMatrixTextField.getText().trim().isEmpty()) {
                            JOptionPane.showMessageDialog(this, "A source data must be informed!", "Error", 0);
                        } else {
                            originalDmat = new DistanceMatrix(this.distanceMatrixTextField.getText());
                            if (originalDmat != null) {
                                silhouette = sc.execute(originalDmat);
                            }
                        }
                    }
                    if (silhouette != null) {
                        float average = sc.average(silhouette);
                        result = result + "Silhouette coefficient:\r\n";
                        result = result + "Original: " + average + "\r\n";
                        result = result + "---\r\n\n";
                        wrote = true;
                        if (this.scalarCheckBox.isSelected()) {
                            if (originalMatrix != null) {
                                this.createScalars(originalMatrix.getClassData(), silhouette, "Original ");
                            } else if (originalDmat != null) {
                                this.createScalars(originalDmat.getClassData(), silhouette, "Original ");
                            }
                        }
                    }
                }
                if (this.projectedCheckBox.isSelected()) {
                    ArrayList<Edge> edges = null;
                    if (this.model.getSelectedConnectivity() != null) {
                        edges = this.model.getSelectedConnectivity().getEdges();
                    } else if (this.model.getConnectivities() != null && this.model.getConnectivities().size() > 1) {
                        edges = this.model.getConnectivities().get(1).getEdges();
                    }
                    if (edges == null) {
                        JOptionPane.showMessageDialog(this, "Problems on retrieving connectivity", "Error", 0);
                        return;
                    }
                    float[] cdata = new float[this.model.getValidInstances().size()];
                    int[] ids = new int[this.model.getValidInstances().size()];
                    for (int i = 0; i < this.model.getValidInstances().size(); ++i) {
                        cdata[i] = ((SimpleTreeInstance)this.model.getValidInstances().get(i)).getScalarValue(this.scalar);
                        ids[i] = this.model.getValidInstances().get(i).getId();
                    }
                    float[] silhouette = sc.execute(edges, ids, cdata, this.useWeightsCheckBox.isSelected());
                    float average = sc.average(silhouette);
                    if (!wrote) {
                        result = result + "Silhouette coefficient:\r\n";
                    }
                    result = result + "Tree: " + average + "\r\n";
                    result = result + "---\r\n";
                    if (this.scalarCheckBox.isSelected()) {
                        this.createScalars(cdata, silhouette, "Projected ");
                    }
                }
                SimpleTreeSilhouetteCoefficientConsole.getInstance(null).display(this.titleTextField.getText().trim(), result);
                this.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(this, "A projection must be provided.", "Error", 0);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.choice = 0;
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.choice = 1;
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DATAFilter(), this.pointsTextField);
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DMATFilter(), this.distanceMatrixTextField);
    }

    private void originalCheckBoxActionPerformed(ActionEvent evt) {
        if (this.originalCheckBox.isSelected()) {
            this.sourcePanel.setVisible(true);
        } else {
            this.sourcePanel.setVisible(false);
        }
        this.pack();
    }

    private void pushButton(AbstractFilter filter, JTextField field) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, filter, this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                field.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeSilhouetteCoefficientView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SimpleTreeSilhouetteCoefficientView getInstance(JFrameModelViewer parent) {
        return new SimpleTreeSilhouetteCoefficientView(parent);
    }

    public void display(SimpleTreeModel model, Scalar scalar) throws IOException {
        this.model = model;
        this.scalar = scalar;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void createScalars(float[] cdata, float[] silhouette, String prefix) throws IOException {
        int i;
        int i2;
        for (int i3 = 0; i3 < silhouette.length; ++i3) {
            silhouette[i3] = (silhouette[i3] + 1.0f) / 2.0f;
        }
        ArrayList<Float> cdata_index = new ArrayList<Float>();
        for (int i4 = 0; i4 < cdata.length; ++i4) {
            if (cdata_index.contains(Float.valueOf(cdata[i4]))) continue;
            cdata_index.add(Float.valueOf(cdata[i4]));
        }
        int[] cluster_id = new int[cdata.length];
        for (int i5 = 0; i5 < cdata.length; ++i5) {
            int index;
            cluster_id[i5] = index = cdata_index.indexOf(Float.valueOf(cdata[i5]));
        }
        float[] clsilhaverage = new float[cdata_index.size()];
        int[] nrel = new int[cdata_index.size()];
        Arrays.fill(nrel, 0);
        Arrays.fill(clsilhaverage, 0.0f);
        for (int i6 = 0; i6 < cdata.length; ++i6) {
            int index;
            int n = index = cdata_index.indexOf(Float.valueOf(cdata[i6]));
            clsilhaverage[n] = clsilhaverage[n] + silhouette[i6];
            int n2 = index;
            nrel[n2] = nrel[n2] + 1;
        }
        float[] clsilhouette = new float[cdata.length];
        for (int i7 = 0; i7 < cdata.length; ++i7) {
            int index = cdata_index.indexOf(Float.valueOf(cdata[i7]));
            clsilhouette[i7] = clsilhaverage[index] / (float)nrel[index];
        }
        float[] normsilhouette = new float[silhouette.length];
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        for (i2 = 0; i2 < silhouette.length; ++i2) {
            if (max < silhouette[i2]) {
                max = silhouette[i2];
            }
            if (!(min > silhouette[i2])) continue;
            min = silhouette[i2];
        }
        for (i2 = 0; i2 < silhouette.length; ++i2) {
            normsilhouette[i2] = (silhouette[i2] - min) / (max - min);
        }
        float[] normclsilhouette = new float[silhouette.length];
        max = Float.NEGATIVE_INFINITY;
        min = Float.POSITIVE_INFINITY;
        for (i = 0; i < clsilhouette.length; ++i) {
            if (max < clsilhouette[i]) {
                max = clsilhouette[i];
            }
            if (!(min > clsilhouette[i])) continue;
            min = clsilhouette[i];
        }
        for (i = 0; i < clsilhouette.length; ++i) {
            normclsilhouette[i] = (clsilhouette[i] - min) / (max - min);
        }
        Scalar silh = this.model.addScalar(prefix + "silhouette");
        Scalar nsilh = this.model.addScalar(prefix + "normalized silhouette");
        Scalar clsilh = this.model.addScalar(prefix + "cluster silhouette");
        Scalar nclsilh = this.model.addScalar(prefix + "normalized cluster silhouette");
        ArrayList<AbstractInstance> instances = this.model.getValidInstances();
        for (int i8 = 0; i8 < instances.size(); ++i8) {
            SimpleTreeInstance gi = (SimpleTreeInstance)instances.get(i8);
            gi.setScalarValue(silh, silhouette[i8]);
            gi.setScalarValue(nsilh, normsilhouette[i8]);
            gi.setScalarValue(clsilh, clsilhouette[i8]);
            gi.setScalarValue(nclsilh, normclsilhouette[i8]);
        }
    }
}

