/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.CharProcedure;
import cern.colt.list.AbstractCharList;
import cern.colt.list.AbstractList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class CharArrayList
extends AbstractCharList {
    protected char[] elements;

    public CharArrayList() {
        this(10);
    }

    public CharArrayList(char[] cArray) {
        this.elements(cArray);
    }

    public CharArrayList(int n) {
        this(new char[n]);
        this.setSizeRaw(0);
    }

    public void add(char c) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = c;
    }

    public void beforeInsert(int n, char c) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = c;
        ++this.size;
    }

    public int binarySearchFromTo(char c, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, c, n, n2);
    }

    public Object clone() {
        CharArrayList charArrayList = new CharArrayList((char[])this.elements.clone());
        charArrayList.setSizeRaw(this.size);
        return charArrayList;
    }

    public CharArrayList copy() {
        return (CharArrayList)this.clone();
    }

    protected void countSortFromTo(int n, int n2, char c, char c2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = c2 - c + 1;
        int[] nArray = new int[n3];
        char[] cArray = this.elements;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = cArray[n4++] - c;
            nArray[n5] = nArray[n5] + 1;
        }
        int n6 = n;
        char c3 = c;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = nArray[n7];
            if (n8 > 0) {
                if (n8 == 1) {
                    cArray[n6++] = c3;
                } else {
                    int n9 = n6 + n8 - 1;
                    this.fillFromToWith(n6, n9, c3);
                    n6 = n9 + 1;
                }
            }
            ++n7;
            c3 = (char)(c3 + '\u0001');
        }
    }

    public char[] elements() {
        return this.elements;
    }

    public AbstractCharList elements(char[] cArray) {
        this.elements = cArray;
        this.size = cArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CharArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        CharArrayList charArrayList = (CharArrayList)object;
        if (this.size() != charArrayList.size()) {
            return false;
        }
        char[] cArray = this.elements();
        char[] cArray2 = charArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (cArray[n] == cArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(CharProcedure charProcedure) {
        char[] cArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (charProcedure.apply(cArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public char get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public char getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(char c, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        char[] cArray = this.elements;
        int n3 = n;
        while (n3 <= n2) {
            if (c == cArray[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOfFromTo(char c, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        char[] cArray = this.elements;
        int n3 = n2;
        while (n3 >= n) {
            if (c == cArray[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public AbstractCharList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new CharArrayList(0);
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        char[] cArray = new char[n2 - n + 1];
        System.arraycopy(this.elements, n, cArray, 0, n2 - n + 1);
        return new CharArrayList(cArray);
    }

    public boolean removeAll(AbstractCharList abstractCharList) {
        double d;
        if (!(abstractCharList instanceof CharArrayList)) {
            return super.removeAll(abstractCharList);
        }
        if (abstractCharList.size() == 0) {
            return false;
        }
        int n = abstractCharList.size() - 1;
        int n2 = 0;
        char[] cArray = this.elements;
        int n3 = this.size();
        double d2 = abstractCharList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            CharArrayList charArrayList = (CharArrayList)abstractCharList.clone();
            charArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (charArrayList.binarySearchFromTo(cArray[n4], 0, n) < 0) {
                    cArray[n2++] = cArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractCharList.indexOfFromTo(cArray[n5], 0, n) < 0) {
                    cArray[n2++] = cArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractCharList abstractCharList, int n3) {
        if (!(abstractCharList instanceof CharArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractCharList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractCharList.size());
            System.arraycopy(((CharArrayList)abstractCharList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractCharList abstractCharList) {
        double d;
        if (!(abstractCharList instanceof CharArrayList)) {
            return super.retainAll(abstractCharList);
        }
        int n = abstractCharList.size() - 1;
        int n2 = 0;
        char[] cArray = this.elements;
        int n3 = this.size();
        double d2 = abstractCharList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            CharArrayList charArrayList = (CharArrayList)abstractCharList.clone();
            charArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (charArrayList.binarySearchFromTo(cArray[n4], 0, n) >= 0) {
                    cArray[n2++] = cArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractCharList.indexOfFromTo(cArray[n5], 0, n) >= 0) {
                    cArray[n2++] = cArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        char[] cArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            cArray[n3++] = cArray[n2];
            cArray[n2--] = c;
        }
    }

    public void set(int n, char c) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = c;
    }

    public void setQuick(int n, char c) {
        this.elements[n] = c;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        char[] cArray = this.elements;
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            char c = cArray[n4];
            cArray[n4] = cArray[n3];
            cArray[n3] = c;
            ++n3;
        }
    }

    public void sortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        char c = this.elements[n];
        char c2 = this.elements[n];
        char[] cArray = this.elements;
        int n3 = n + 1;
        while (n3 <= n2) {
            char c3;
            if ((c3 = cArray[n3++]) > c2) {
                c2 = c3;
                continue;
            }
            if (c3 >= c) continue;
            c = c3;
        }
        double d = (double)n2 - (double)n + 1.0;
        double d2 = d * Math.log(d) / 0.6931471805599453;
        double d3 = (double)c2 - (double)c + 1.0;
        double d4 = Math.max(d3, d);
        if (d3 < 10000.0 && d4 < d2) {
            this.countSortFromTo(n, n2, c, c2);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

