/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.ShortProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.AbstractShortList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class ShortArrayList
extends AbstractShortList {
    protected short[] elements;

    public ShortArrayList() {
        this(10);
    }

    public ShortArrayList(short[] sArray) {
        this.elements(sArray);
    }

    public ShortArrayList(int n) {
        this(new short[n]);
        this.setSizeRaw(0);
    }

    public void add(short s) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = s;
    }

    public void beforeInsert(int n, short s) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = s;
        ++this.size;
    }

    public int binarySearchFromTo(short s, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, s, n, n2);
    }

    public Object clone() {
        ShortArrayList shortArrayList = new ShortArrayList((short[])this.elements.clone());
        shortArrayList.setSizeRaw(this.size);
        return shortArrayList;
    }

    public ShortArrayList copy() {
        return (ShortArrayList)this.clone();
    }

    protected void countSortFromTo(int n, int n2, short s, short s2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = s2 - s + 1;
        int[] nArray = new int[n3];
        short[] sArray = this.elements;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = sArray[n4++] - s;
            nArray[n5] = nArray[n5] + 1;
        }
        int n6 = n;
        short s3 = s;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = nArray[n7];
            if (n8 > 0) {
                if (n8 == 1) {
                    sArray[n6++] = s3;
                } else {
                    int n9 = n6 + n8 - 1;
                    this.fillFromToWith(n6, n9, s3);
                    n6 = n9 + 1;
                }
            }
            ++n7;
            s3 = (short)(s3 + 1);
        }
    }

    public short[] elements() {
        return this.elements;
    }

    public AbstractShortList elements(short[] sArray) {
        this.elements = sArray;
        this.size = sArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ShortArrayList shortArrayList = (ShortArrayList)object;
        if (this.size() != shortArrayList.size()) {
            return false;
        }
        short[] sArray = this.elements();
        short[] sArray2 = shortArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (sArray[n] == sArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(ShortProcedure shortProcedure) {
        short[] sArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (shortProcedure.apply(sArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public short get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public short getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(short s, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        short[] sArray = this.elements;
        int n3 = n;
        while (n3 <= n2) {
            if (s == sArray[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOfFromTo(short s, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        short[] sArray = this.elements;
        int n3 = n2;
        while (n3 >= n) {
            if (s == sArray[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public AbstractShortList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new ShortArrayList(0);
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        short[] sArray = new short[n2 - n + 1];
        System.arraycopy(this.elements, n, sArray, 0, n2 - n + 1);
        return new ShortArrayList(sArray);
    }

    public boolean removeAll(AbstractShortList abstractShortList) {
        double d;
        if (!(abstractShortList instanceof ShortArrayList)) {
            return super.removeAll(abstractShortList);
        }
        if (abstractShortList.size() == 0) {
            return false;
        }
        int n = abstractShortList.size() - 1;
        int n2 = 0;
        short[] sArray = this.elements;
        int n3 = this.size();
        double d2 = abstractShortList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            ShortArrayList shortArrayList = (ShortArrayList)abstractShortList.clone();
            shortArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (shortArrayList.binarySearchFromTo(sArray[n4], 0, n) < 0) {
                    sArray[n2++] = sArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractShortList.indexOfFromTo(sArray[n5], 0, n) < 0) {
                    sArray[n2++] = sArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractShortList abstractShortList, int n3) {
        if (!(abstractShortList instanceof ShortArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractShortList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractShortList.size());
            System.arraycopy(((ShortArrayList)abstractShortList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractShortList abstractShortList) {
        double d;
        if (!(abstractShortList instanceof ShortArrayList)) {
            return super.retainAll(abstractShortList);
        }
        int n = abstractShortList.size() - 1;
        int n2 = 0;
        short[] sArray = this.elements;
        int n3 = this.size();
        double d2 = abstractShortList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            ShortArrayList shortArrayList = (ShortArrayList)abstractShortList.clone();
            shortArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (shortArrayList.binarySearchFromTo(sArray[n4], 0, n) >= 0) {
                    sArray[n2++] = sArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractShortList.indexOfFromTo(sArray[n5], 0, n) >= 0) {
                    sArray[n2++] = sArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        short[] sArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            short s = sArray[n3];
            sArray[n3++] = sArray[n2];
            sArray[n2--] = s;
        }
    }

    public void set(int n, short s) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = s;
    }

    public void setQuick(int n, short s) {
        this.elements[n] = s;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        short[] sArray = this.elements;
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            short s = sArray[n4];
            sArray[n4] = sArray[n3];
            sArray[n3] = s;
            ++n3;
        }
    }

    public void sortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        short s = this.elements[n];
        short s2 = this.elements[n];
        short[] sArray = this.elements;
        int n3 = n + 1;
        while (n3 <= n2) {
            short s3;
            if ((s3 = sArray[n3++]) > s2) {
                s2 = s3;
                continue;
            }
            if (s3 >= s) continue;
            s = s3;
        }
        double d = (double)n2 - (double)n + 1.0;
        double d2 = d * Math.log(d) / 0.6931471805599453;
        double d3 = (double)s2 - (double)s + 1.0;
        double d4 = Math.max(d3, d);
        if (d3 < 10000.0 && d4 < d2) {
            this.countSortFromTo(n, n2, s, s2);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

