/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.Callable;
import edu.oswego.cs.dl.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;

public class FutureResult {
    protected Object value_ = null;
    protected boolean ready_ = false;
    protected InvocationTargetException exception_ = null;

    public Runnable setter(final Callable callable) {
        return new Runnable(){

            public void run() {
                try {
                    FutureResult.this.set(callable.call());
                }
                catch (Throwable throwable) {
                    FutureResult.this.setException(throwable);
                }
            }
        };
    }

    protected Object doGet() throws InvocationTargetException {
        if (this.exception_ != null) {
            throw this.exception_;
        }
        return this.value_;
    }

    public synchronized Object get() throws InterruptedException, InvocationTargetException {
        while (!this.ready_) {
            this.wait();
        }
        return this.doGet();
    }

    public synchronized Object timedGet(long l) throws TimeoutException, InterruptedException, InvocationTargetException {
        long l2 = l <= 0L ? 0L : System.currentTimeMillis();
        long l3 = l;
        if (this.ready_) {
            return this.doGet();
        }
        if (l3 <= 0L) {
            throw new TimeoutException(l);
        }
        do {
            this.wait(l3);
            if (!this.ready_) continue;
            return this.doGet();
        } while ((l3 = l - (System.currentTimeMillis() - l2)) > 0L);
        throw new TimeoutException(l);
    }

    public synchronized void set(Object object) {
        this.value_ = object;
        this.ready_ = true;
        this.notifyAll();
    }

    public synchronized void setException(Throwable throwable) {
        this.exception_ = new InvocationTargetException(throwable);
        this.ready_ = true;
        this.notifyAll();
    }

    public synchronized InvocationTargetException getException() {
        return this.exception_;
    }

    public synchronized boolean isReady() {
        return this.ready_;
    }

    public synchronized Object peek() {
        return this.value_;
    }

    public synchronized void clear() {
        this.value_ = null;
        this.exception_ = null;
        this.ready_ = false;
    }
}

