/*
 * Decompiled with CFR 0.152.
 */
package jal.SHORT;

import jal.SHORT.BinaryOperator;
import jal.SHORT.BinaryPredicate;
import jal.SHORT.Generator;
import jal.SHORT.Inspection;
import jal.SHORT.Predicate;
import jal.SHORT.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(short[] sArray, short[] sArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(sArray, n, sArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(short[] sArray, short[] sArray2, int n, int n2, int n3) {
        while (n < n2) {
            short s = sArray2[n3];
            sArray2[n3] = sArray[n];
            sArray[n] = s;
            ++n;
            ++n3;
        }
    }

    public static void transform(short[] sArray, short[] sArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            sArray2[n3++] = unaryOperator.apply(sArray[n++]);
        }
    }

    public static void transform(short[] sArray, short[] sArray2, short[] sArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            sArray3[n4++] = binaryOperator.apply(sArray[n++], sArray2[n3++]);
        }
    }

    public static void replace(short[] sArray, int n, int n2, short s, short s2) {
        while (n < n2) {
            if (sArray[n] == s) {
                sArray[n] = s2;
            }
            ++n;
        }
    }

    public static void replace_if(short[] sArray, int n, int n2, Predicate predicate, short s) {
        while (n < n2) {
            if (predicate.apply(sArray[n])) {
                sArray[n] = s;
            }
            ++n;
        }
    }

    public static void replace_copy(short[] sArray, short[] sArray2, int n, int n2, int n3, short s, short s2) {
        while (n < n2) {
            short s3 = sArray[n++];
            short s4 = sArray2[n3++] = s3 == s ? s2 : s3;
        }
    }

    public static void replace_copy_if(short[] sArray, short[] sArray2, int n, int n2, int n3, Predicate predicate, short s) {
        while (n < n2) {
            short s2 = sArray[n++];
            short s3 = sArray2[n3++] = predicate.apply(s2) ? s : s2;
        }
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        while (n < n2) {
            sArray[n++] = s;
        }
    }

    public static void generate(short[] sArray, int n, int n2, Generator generator) {
        while (n < n2) {
            sArray[n++] = generator.apply();
        }
    }

    public static int remove_if(short[] sArray, int n, int n2, short s) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && sArray[n] != s) {
                continue;
            }
            while (n < --n2 && sArray[n2] == s) {
            }
            if (n >= n2) {
                return n;
            }
            sArray[n] = sArray[n2];
        }
    }

    public static int remove_if(short[] sArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(sArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(sArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            sArray[n] = sArray[n2];
        }
    }

    public static int stable_remove(short[] sArray, int n, int n2, short s) {
        n = Inspection.find(sArray, n, n2, s);
        int n3 = Inspection.find_not(sArray, n, n2, s);
        while (n3 < n2) {
            sArray[n++] = sArray[n3];
            ++n3;
            n3 = Inspection.find_not(sArray, n3, n2, s);
        }
        return n;
    }

    public static int stable_remove_if(short[] sArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(sArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(sArray, n, n2, predicate);
        while (n3 < n2) {
            sArray[n++] = sArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(sArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(short[] sArray, short[] sArray2, int n, int n2, int n3, short s) {
        while (n < n2) {
            short s2;
            if ((s2 = sArray[n++]) == s) continue;
            sArray2[n3++] = s2;
        }
        return n3;
    }

    public static int remove_copy_if(short[] sArray, short[] sArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            short s;
            if (predicate.apply(s = sArray[n++])) continue;
            sArray2[n3++] = s;
        }
        return n3;
    }

    public static int unique(short[] sArray, int n, int n2) {
        n = Inspection.adjacent_find(sArray, n, n2);
        return Modification.unique_copy(sArray, sArray, n, n2, n);
    }

    public static int unique(short[] sArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(sArray, n, n2, binaryPredicate);
        return Modification.unique_copy(sArray, sArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(short[] sArray, short[] sArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        sArray2[n3] = sArray[n];
        while (++n < n2) {
            if (sArray2[n3] == sArray[n]) continue;
            sArray2[++n3] = sArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(short[] sArray, short[] sArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        sArray2[n3] = sArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(sArray2[n3], sArray[n])) continue;
            sArray2[++n3] = sArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(short[] sArray, int n, int n2) {
        while (n < --n2) {
            short s = sArray[n];
            sArray[n++] = sArray[n2];
            sArray[n2] = s;
        }
    }

    public static void reverse_copy(short[] sArray, int n, int n2, int n3) {
        while (n2 > n) {
            sArray[n3++] = sArray[--n2];
        }
    }

    public static void reverse_copy(short[] sArray, short[] sArray2, int n, int n2, int n3) {
        while (n2 > n) {
            sArray2[n3++] = sArray[--n2];
        }
    }

    public static void rotate(short[] sArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(sArray, n, n2);
            Modification.reverse(sArray, n2, n3);
            Modification.reverse(sArray, n, n3);
        }
    }

    public static void rotate_copy(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4) {
        Modification.copy(sArray, sArray2, n2, n3, n4);
        Modification.copy(sArray, sArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(short[] sArray, int n, int n2, Random random) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random.nextInt()) % (n3 - n + 1);
            short s = sArray[n4];
            sArray[n4] = sArray[n3];
            sArray[n3] = s;
            ++n3;
        }
    }

    public static void random_shuffle(short[] sArray, int n, int n2) {
        Modification.random_shuffle(sArray, n, n2, default_RNG);
    }

    public static int partition(short[] sArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(sArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(sArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            short s = sArray[n];
            sArray[n] = sArray[n2];
            sArray[n2] = s;
        }
    }

    public static int stable_partition(short[] sArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(sArray, n, n3, predicate);
            int n5 = Modification.stable_partition(sArray, n3, n2, predicate);
            Modification.rotate(sArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(sArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

