/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.DataCluster;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import jclusteroutline.Outline;
import jclusteroutline.Vector2d;

public class TestCore {
    private Outline outlineAlg = new Outline();
    private ArrayList<DataCluster> dataClusters = new ArrayList();
    private int selectedCluster = 0;
    private double xDif;
    private double yDif;

    public TestCore(double width, double height) {
        this.xDif = width;
        this.yDif = height;
        this.addCluster(this.createRandomDataSet());
    }

    public void setCoordinates(double width, double height) {
        this.xDif = width;
        this.yDif = height;
    }

    public void addPointToCluster(Vector2d pos, int clusterIndex) {
        this.dataClusters.get(clusterIndex).addDataPoint(pos);
    }

    public void addCluster(ArrayList<Vector2d> newClusterData) {
        this.selectedCluster = this.dataClusters.size();
        this.dataClusters.add(new DataCluster(this.getOutlineAlg(), newClusterData, new Dimension((int)this.xDif, (int)this.yDif)));
    }

    public void addCluster() {
        this.selectedCluster = this.dataClusters.size();
        this.dataClusters.add(new DataCluster(this.getOutlineAlg()));
    }

    public void removeCluster(int clusterIndex) {
        this.dataClusters.remove(clusterIndex);
        if (this.dataClusters.isEmpty()) {
            this.addCluster();
        } else if (clusterIndex == this.selectedCluster) {
            --this.selectedCluster;
        }
    }

    public void removeSelectedCluster() {
        this.removeCluster(this.selectedCluster);
    }

    public void removeAllClusters() {
        this.selectedCluster = 0;
        this.dataClusters = new ArrayList();
        this.addCluster();
    }

    public Vector2d transformCoordinatesIn(double x, double y) {
        return new Vector2d(x / this.xDif, y / this.yDif);
    }

    public Vector2d transformCoordinatesIn(Point2D point) {
        return this.transformCoordinatesIn(point.getX(), point.getY());
    }

    public Point2D.Double transformCoordinatesOut(Vector2d vec) {
        return new Point2D.Double(vec.getX() * this.xDif, vec.getY() * this.yDif);
    }

    public ArrayList<Vector2d> createRandomDataSet() {
        ArrayList<Vector2d> newDataSet = new ArrayList<Vector2d>();
        for (int cnt = 0; cnt < 10; ++cnt) {
            Vector2d newPoint = this.transformCoordinatesIn(Math.random() * this.xDif, Math.random() * this.yDif);
            newDataSet.add(newPoint);
        }
        return newDataSet;
    }

    public void randomizeSelectedClusterColor() {
        this.dataClusters.get(this.selectedCluster).randomizeClusterColor();
    }

    public void randomizeAllClusterColor() {
        Iterator<DataCluster> iter = this.dataClusters.iterator();
        while (iter.hasNext()) {
            iter.next().randomizeClusterColor();
        }
    }

    private void redoAllOutlines() {
        Iterator<DataCluster> iter = this.dataClusters.iterator();
        while (iter.hasNext()) {
            iter.next().redoOutline();
        }
    }

    protected ArrayList<DataCluster> getDataClusters() {
        return this.dataClusters;
    }

    protected int getSelectedCluster() {
        return this.selectedCluster;
    }

    protected void setSelectedCluster(int selectedCluster) {
        this.selectedCluster = selectedCluster;
    }

    public void setLaplacianNumIterations(int num_iterations) {
        this.getOutlineAlg().setLaplacianNumIterations(num_iterations);
        this.redoAllOutlines();
    }

    public void setLaplacianLambda(double lambda) {
        this.getOutlineAlg().setLaplacianLambda(lambda);
        this.redoAllOutlines();
    }

    public void setSamplingDistance(double sampling_distance) {
        this.getOutlineAlg().setSamplingDistance(sampling_distance);
        this.redoAllOutlines();
    }

    public void setPadding(double padding) {
        this.getOutlineAlg().setPadding(padding);
        this.redoAllOutlines();
    }

    public Outline getOutlineAlg() {
        return this.outlineAlg;
    }

    public void setOutlineAlg(Outline outlineAlg) {
        this.outlineAlg = outlineAlg;
    }
}

