/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.DataCluster;
import example.TestCore;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import jclusteroutline.Outline;
import jclusteroutline.Vector2d;

public class drawPanel
extends JPanel
implements MouseListener {
    private TestCore core;
    private boolean showOutlines;

    public drawPanel() {
        this.initComponents();
        this.showOutlines = true;
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
        if (this.core != null) {
            this.drawDataPoints(g2, 8);
        }
    }

    private void drawDataPoints(Graphics g, int mRadius) {
        int radius = mRadius > 0 ? mRadius - 1 : mRadius;
        int halfRadius = radius / 2;
        for (DataCluster cluster : this.core.getDataClusters()) {
            ArrayList<Vector2d> dataSet = cluster.getDataSet();
            ArrayList<Vector2d> outlineSet = cluster.getOutlineSet();
            Color clusterColor = cluster.getClusterColor();
            Iterator<Vector2d> iterPoints = dataSet.iterator();
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            while (iterPoints.hasNext()) {
                Point2D.Double convertedPoint = this.core.transformCoordinatesOut(iterPoints.next());
                int x = (int)((Point2D)convertedPoint).getX();
                int y = (int)((Point2D)convertedPoint).getY();
                g.setColor(clusterColor);
                g.fillOval(x - halfRadius, y - halfRadius, radius, radius);
                g.setColor(Color.BLACK);
                g.drawOval(x - halfRadius, y - halfRadius, radius, radius);
                points.add(new Point2D.Float(x, y));
            }
            if (!this.showOutlines) continue;
            Outline out = new Outline();
            out.setPadding(this.core.getOutlineAlg().getPadding());
            out.setLaplacianLambda(this.core.getOutlineAlg().getLaplacianLambda());
            out.setLaplacianNumIterations(this.core.getOutlineAlg().getLaplacian_num_iterations());
            out.setSamplingDistance(this.core.getOutlineAlg().getSamplingDistance());
            out.compute(points, this.getSize());
            g.drawPolygon(out.getPolygon());
        }
    }

    private void drawOutlines(Graphics g, ArrayList<Vector2d> outlineSet) {
        Point2D.Double lineStart = null;
        Point2D.Double lineEnd = null;
        int outlineSize = outlineSet.size();
        if (outlineSize < 1) {
            return;
        }
        lineStart = this.core.transformCoordinatesOut(outlineSet.get(0));
        g.setColor(Color.CYAN);
        Polygon pol = new Polygon();
        for (int cnt = 1; cnt < outlineSize; ++cnt) {
            lineEnd = this.core.transformCoordinatesOut(outlineSet.get(cnt));
            pol.addPoint((int)((Point2D)lineStart).getX(), (int)((Point2D)lineStart).getY());
            pol.addPoint((int)((Point2D)lineEnd).getX(), (int)((Point2D)lineEnd).getY());
            lineStart = lineEnd;
        }
        pol.addPoint((int)((Point2D)lineStart).getX(), (int)((Point2D)lineStart).getY());
        lineEnd = this.core.transformCoordinatesOut(outlineSet.get(0));
        pol.addPoint((int)((Point2D)lineEnd).getX(), (int)((Point2D)lineEnd).getY());
        g.fillPolygon(pol);
        g.setColor(Color.LIGHT_GRAY);
        g.drawPolygon(pol);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.core.addPointToCluster(this.core.transformCoordinatesIn(e.getX(), e.getY()), this.core.getSelectedCluster());
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setTestCore(TestCore core) {
        this.core = core;
    }

    public boolean isShowOutlines() {
        return this.showOutlines;
    }

    public void setShowOutlines(boolean showOutlines) {
        this.showOutlines = showOutlines;
    }

    public void toggleShowOutlines() {
        this.showOutlines = !this.showOutlines;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

