/*
 * Decompiled with CFR 0.152.
 */
package jclusteroutline;

import java.util.ArrayList;
import java.util.Collections;
import jclusteroutline.Vector2d;

public class Geometry {
    public static double EPSILON = 1.0E-9;

    public static double cross(Vector2d p, Vector2d q, Vector2d r) {
        return (q.getX() - p.getX()) * (r.getY() - p.getY()) - (q.getY() - p.getY()) * (r.getX() - p.getX());
    }

    public static double dist(Vector2d a, Vector2d b) {
        return a.subtractC(b).length();
    }

    public static double dist_sq(Vector2d a, Vector2d b) {
        double dist = Geometry.dist(a, b);
        return dist * dist;
    }

    public static void ensureArrayListCap(Object b, int n) {
        ArrayList a = (ArrayList)b;
        int size = a.size();
        if (size < n) {
            for (int dif = size; dif < n; ++dif) {
                a.add(null);
            }
        } else {
            for (int dif = size; dif > n; --dif) {
                a.remove(dif - 1);
            }
        }
    }

    public static ArrayList<Vector2d> convex_hull(ArrayList<Vector2d> P) {
        int i;
        int n = P.size();
        int k = 0;
        ArrayList<Vector2d> H = new ArrayList<Vector2d>(2 * n);
        Geometry.ensureArrayListCap(H, 2 * n);
        Collections.sort(P);
        for (i = 0; i < n; ++i) {
            while (k >= 2 && Geometry.cross((Vector2d)H.get(k - 2), (Vector2d)H.get(k - 1), P.get(i)) <= 0.0) {
                --k;
            }
            H.set(k++, P.get(i));
        }
        int t = k + 1;
        for (i = n - 2; i >= 0; --i) {
            while (k >= t && Geometry.cross(H.get(k - 2), H.get(k - 1), P.get(i)) <= 0.0) {
                --k;
            }
            H.set(k++, P.get(i));
        }
        Geometry.ensureArrayListCap(H, k);
        return H;
    }

    public static boolean in_range(Vector2d p, Vector2d q, Vector2d r) {
        return r.getX() <= Math.max(p.getX(), q.getX()) && r.getX() >= Math.min(p.getX(), q.getX()) && r.getY() <= Math.max(p.getY(), q.getY()) && r.getY() >= Math.min(p.getY(), q.getY());
    }

    public static boolean line_segments_intersect(Vector2d p1, Vector2d q1, Vector2d p2, Vector2d q2) {
        double a1 = q1.getY() - p1.getY();
        double b1 = p1.getX() - q1.getX();
        double c1 = a1 * p1.getX() + b1 * p1.getY();
        double a2 = q2.getY() - p2.getY();
        double b2 = p2.getX() - q2.getX();
        double c2 = a2 * p2.getX() + b2 * p2.getY();
        double det = a1 * b2 - a2 * b1;
        if (Math.abs(det) < EPSILON) {
            return Geometry.in_range(p1, q1, p2) || Geometry.in_range(p1, q1, q2) || Geometry.in_range(p2, q2, p1) || Geometry.in_range(p2, q2, q1);
        }
        Vector2d r = new Vector2d((b2 * c1 - b1 * c2) / det, (a1 * c2 - a2 * c1) / det);
        return Geometry.in_range(p1, q1, r) && Geometry.in_range(p2, q2, r);
    }
}

