/*
 * Decompiled with CFR 0.152.
 */
package jclusteroutline;

import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jclusteroutline.Geometry;
import jclusteroutline.Vector2d;
import net.sf.javaml.core.kdtree.KDTree;

public class Outline {
    private ArrayList<Vector2d> cluster_ = new ArrayList();
    private ArrayList<Vector2d> hull_ = new ArrayList();
    private ArrayList<Integer> after_ = new ArrayList();
    private ArrayList<Integer> before_ = new ArrayList();
    private KDTree kd_tree_ = null;
    private int laplacian_num_iterations_ = 10;
    private double laplacian_lambda_ = 0.5;
    private double sampling_distance_ = 0.02;
    private double padding_ = 0.04;
    private double amount_to_eat_ = 0.01;
    private Polygon polygon;
    public List<Integer> pointsIds;

    public ArrayList<Vector2d> compute(List<Point2D> points, Dimension dim) {
        for (Point2D p : points) {
            this.cluster_.add(new Vector2d(p.getX() / (double)dim.width, p.getY() / (double)dim.height));
        }
        this.create_kd_tree();
        this.hull_ = Geometry.convex_hull(this.cluster_);
        if (this.hull_.size() > 2) {
            this.inflate_outline();
            this.sample_outline();
            this.termites_eat();
            if (this.hull_.isEmpty()) {
                return null;
            }
            for (int i = 0; i < this.laplacian_num_iterations_; ++i) {
                this.laplacian_smoothing();
            }
            ArrayList<Vector2d> final_hull = new ArrayList<Vector2d>();
            int p = 0;
            while (this.after_.get(p) != 0) {
                final_hull.add(this.hull_.get(p));
                p = this.after_.get(p);
            }
            final_hull.add(this.hull_.get(p));
            this.hull_ = final_hull;
        }
        Point2D.Double lineStart = null;
        Point2D.Double lineEnd = null;
        int outlineSize = this.hull_.size();
        if (outlineSize < 1) {
            return null;
        }
        lineStart = new Point2D.Double(this.hull_.get(0).getX() * (double)dim.width, this.hull_.get(0).getY() * (double)dim.height);
        Polygon pol = new Polygon();
        for (int cnt = 1; cnt < outlineSize; ++cnt) {
            lineEnd = new Point2D.Double(this.hull_.get(cnt).getX() * (double)dim.width, this.hull_.get(cnt).getY() * (double)dim.height);
            pol.addPoint((int)((Point2D)lineStart).getX(), (int)((Point2D)lineStart).getY());
            pol.addPoint((int)((Point2D)lineEnd).getX(), (int)((Point2D)lineEnd).getY());
            lineStart = lineEnd;
        }
        pol.addPoint((int)((Point2D)lineStart).getX(), (int)((Point2D)lineStart).getY());
        lineEnd = new Point2D.Double(this.hull_.get(0).getX() * (double)dim.width, this.hull_.get(0).getY() * (double)dim.height);
        pol.addPoint((int)((Point2D)lineEnd).getX(), (int)((Point2D)lineEnd).getY());
        this.polygon = pol;
        return this.hull_;
    }

    private Vector2d get_face_normal(Vector2d p, Vector2d before, Vector2d after) {
        Vector2d left_normal = p.subtractC(before).normalizeClone().right_perpendicular();
        Vector2d right_normal = p.subtractC(after).normalizeClone().left_perpendicular();
        return left_normal.addC(right_normal).normalizeClone();
    }

    private Vector2d get_face_normal_composed(int p) {
        Vector2d n1 = this.hull_.get(this.before_.get(p)).subtractC(this.hull_.get(this.before_.get(this.before_.get(p)))).normalizeClone().right_perpendicular();
        Vector2d n2 = this.hull_.get(p).subtractC(this.hull_.get(this.before_.get(p))).normalizeClone().right_perpendicular();
        Vector2d n3 = this.hull_.get(p).subtractC(this.hull_.get(this.after_.get(p))).normalizeClone().left_perpendicular();
        Vector2d n4 = this.hull_.get(this.after_.get(p)).subtractC(this.hull_.get(this.after_.get(this.after_.get(p)))).normalizeClone().left_perpendicular();
        return n1.multiplyC(0.125).addC(n2.multiplyC(0.375)).addC(n3.multiplyC(0.375)).addC(n4.multiplyC(0.125)).normalizeClone();
    }

    private void inflate_outline() {
        int i;
        assert (this.hull_.size() > 2);
        double amount_to_inflate = this.padding_;
        ArrayList<Vector2d> p = new ArrayList<Vector2d>();
        for (i = 0; i < this.hull_.size(); ++i) {
            int after = i == this.hull_.size() - 1 ? 1 : i + 1;
            p.add(this.hull_.get(i));
            p.add(this.hull_.get(i).addC(this.hull_.get(after)).divideC(2.0));
        }
        this.hull_ = p;
        p = new ArrayList();
        for (i = 0; i < this.hull_.size(); ++i) {
            int before = i == 0 ? this.hull_.size() - 2 : i - 1;
            int after = i == this.hull_.size() - 1 ? 1 : i + 1;
            Vector2d average_normal = new Vector2d();
            for (int j = 0; j < this.hull_.size(); ++j) {
                average_normal.add(this.hull_.get(i).subtractC(this.hull_.get(j)).normalizeClone());
            }
            p.add(this.hull_.get(i).addC(average_normal.normalizeClone().multiplyC(amount_to_inflate)));
            Vector2d face_normal = this.get_face_normal(this.hull_.get(i), this.hull_.get(before), this.hull_.get(after));
            p.add(this.hull_.get(i).addC(face_normal.multiplyC(amount_to_inflate)));
        }
        if (this.hull_.get(0).epsilonEquals(this.hull_.get(this.hull_.size() - 1))) {
            this.hull_.remove(this.hull_.size() - 1);
        }
        p = Geometry.convex_hull(p);
        this.hull_ = p;
    }

    private void sample_outline() {
        int i;
        double perimeter = 0.0;
        if (this.hull_.get(0).epsilonEquals(this.hull_.get(this.hull_.size() - 1))) {
            this.hull_.remove(this.hull_.size() - 1);
        }
        ArrayList<Double> distances = new ArrayList<Double>(this.hull_.size());
        Geometry.ensureArrayListCap(distances, this.hull_.size());
        for (int i2 = 0; i2 < this.hull_.size(); ++i2) {
            int after = i2 == this.hull_.size() - 1 ? 0 : i2 + 1;
            double d = Geometry.dist(this.hull_.get(i2), this.hull_.get(after));
            distances.set(i2, perimeter);
            perimeter += d;
        }
        int num_points = (int)Math.floor(perimeter / this.sampling_distance_);
        ArrayList<Vector2d> points = new ArrayList<Vector2d>(num_points);
        Geometry.ensureArrayListCap(points, num_points);
        for (i = 0; i < num_points; ++i) {
            int p1;
            boolean found;
            double d = (double)i * this.sampling_distance_;
            Iterator iter = distances.iterator();
            Double lower = (Double)iter.next();
            int indexLower = 0;
            int indexTemp = 0;
            Double temp = lower;
            boolean bl = found = lower >= d;
            while (iter.hasNext()) {
                ++indexTemp;
                temp = (Double)iter.next();
                if (!(temp >= d)) continue;
                if (found) {
                    if (!(temp < lower)) continue;
                    lower = temp;
                    indexLower = indexTemp;
                    continue;
                }
                lower = temp;
                indexLower = indexTemp;
                found = true;
            }
            if (!found) {
                lower = temp;
                indexLower = indexTemp + 1;
            }
            if ((p1 = indexLower) == this.hull_.size() || d != (Double)distances.get(p1)) {
                --p1;
            }
            int p2 = p1 == this.hull_.size() - 1 ? 0 : 1 + p1;
            points.set(i, this.hull_.get(p1).addC(this.hull_.get(p2).subtractC(this.hull_.get(p1)).normalizeClone().multiplyC(d - (Double)distances.get(p1))));
        }
        this.hull_ = points;
        this.after_.ensureCapacity(this.hull_.size());
        this.before_.ensureCapacity(this.hull_.size());
        Geometry.ensureArrayListCap(this.after_, this.hull_.size());
        Geometry.ensureArrayListCap(this.before_, this.hull_.size());
        for (i = 0; i < this.hull_.size(); ++i) {
            this.after_.set(i, i + 1);
            this.before_.set(i, i - 1);
        }
        this.after_.set(this.after_.size() - 1, 0);
        this.before_.set(0, this.hull_.size() - 1);
    }

    private void add_sample_point(Vector2d p, int pos) {
        if (pos >= this.hull_.size()) {
            return;
        }
        this.hull_.add(p);
        if (this.hull_.isEmpty()) {
            this.after_.add(0);
            this.before_.add(0);
        } else {
            this.before_.add(pos);
            this.after_.add(this.after_.get(pos));
            this.before_.set(this.after_.get(pos), this.hull_.size() - 1);
            this.after_.set(pos, this.hull_.size() - 1);
        }
    }

    private void termites_eat() {
        ArrayList<Boolean> active = new ArrayList<Boolean>(this.hull_.size());
        Geometry.ensureArrayListCap(active, this.hull_.size());
        for (int cnt = 0; cnt < this.hull_.size(); ++cnt) {
            active.set(cnt, true);
        }
        int active_count = this.hull_.size();
        this.amount_to_eat_ = this.sampling_distance_ * 0.5;
        while (active_count > 0) {
            int p = 0;
            while (active_count > 0) {
                if (((Boolean)active.get(p)).booleanValue()) {
                    Vector2d face_normal = this.get_face_normal_composed(p);
                    this.hull_.get(p).subtract(face_normal.multiplyC(this.amount_to_eat_));
                    for (int q = 0; ((Boolean)active.get(p)).booleanValue() && q < this.hull_.size(); ++q) {
                        if (q == p || q == this.before_.get(p) || q == this.before_.get(this.before_.get(p)) || q == this.after_.get(p) || !Geometry.line_segments_intersect(this.hull_.get(p), this.hull_.get(this.after_.get(p)), this.hull_.get(q), this.hull_.get(this.after_.get(q))) && !Geometry.line_segments_intersect(this.hull_.get(p), this.hull_.get(this.before_.get(p)), this.hull_.get(q), this.hull_.get(this.after_.get(q)))) continue;
                        active.set(p, false);
                        break;
                    }
                    if (Geometry.line_segments_intersect(this.hull_.get(this.after_.get(p)), this.hull_.get(this.after_.get(this.after_.get(p))), this.hull_.get(this.before_.get(p)), this.hull_.get(p)) || Geometry.line_segments_intersect(this.hull_.get(p), this.hull_.get(this.after_.get(p)), this.hull_.get(this.before_.get(this.before_.get(p))), this.hull_.get(this.before_.get(p)))) {
                        active.set(p, false);
                    }
                    if (((Boolean)active.get(p)).booleanValue() && this.in_range_with_other_points_in_the_hull(this.hull_.get(p), this.padding_)) {
                        active.set(p, false);
                    }
                    if (!((Boolean)active.get(p)).booleanValue()) {
                        --active_count;
                        this.hull_.get(p).add(face_normal.multiplyC(this.amount_to_eat_));
                    } else {
                        if (Geometry.dist(this.hull_.get(p), this.hull_.get(this.after_.get(p))) > 2.0 * this.sampling_distance_) {
                            this.add_sample_point(this.hull_.get(p).addC(this.hull_.get(this.after_.get(p))).divideC(2.0), p);
                            ++active_count;
                            active.add(true);
                        }
                        if (Geometry.dist(this.hull_.get(p), this.hull_.get(this.before_.get(p))) > 2.0 * this.sampling_distance_) {
                            this.add_sample_point(this.hull_.get(p).addC(this.hull_.get(this.before_.get(p))).divideC(2.0), this.before_.get(p));
                            ++active_count;
                            active.add(true);
                        }
                    }
                }
                p = this.after_.get(p);
            }
            this.laplacian_smoothing();
        }
    }

    private void create_kd_tree() {
        this.kd_tree_ = new KDTree(2);
        for (Vector2d tempPoint : this.cluster_) {
            double[] tempCoord = tempPoint.toArray();
            this.kd_tree_.insert(tempCoord, (Object)tempPoint);
        }
    }

    private boolean in_range_with_other_points_in_the_hull(Vector2d p, double safe_distance) {
        if (this.kd_tree_ == null) {
            System.out.println("kd-tree not created yet");
            return false;
        }
        Vector2d inRange = (Vector2d)this.kd_tree_.nearest(p.toArray());
        return Geometry.dist(inRange, p) < safe_distance;
    }

    private void laplacian_smoothing() {
        ArrayList<Object> v = new ArrayList<Vector2d>(this.hull_.size());
        Geometry.ensureArrayListCap(v, this.hull_.size());
        for (int i = 0; i < 1; ++i) {
            for (int p = 0; p < this.hull_.size(); ++p) {
                v.set(p, this.hull_.get(p).addC(this.hull_.get(this.before_.get(p)).addC(this.hull_.get(this.after_.get(p))).divideC(2.0).subtractC(this.hull_.get(p)).multiplyC(this.laplacian_lambda_)));
                if (!this.in_range_with_other_points_in_the_hull((Vector2d)v.get(p), this.padding_ / 2.0)) continue;
                v.set(p, this.hull_.get(p));
            }
            ArrayList<Vector2d> temp = this.hull_;
            this.hull_ = v;
            v = temp;
        }
    }

    public void setSamplingDistance(double sampling_distance) {
        this.sampling_distance_ = sampling_distance;
    }

    public void setPadding(double padding) {
        this.padding_ = padding;
    }

    public double getSamplingDistance() {
        return this.sampling_distance_;
    }

    public double getPadding() {
        return this.padding_;
    }

    public void setLaplacianNumIterations(int num_iterations) {
        this.laplacian_num_iterations_ = num_iterations;
    }

    public void setLaplacianLambda(double lambda) {
        this.laplacian_lambda_ = lambda;
    }

    public double getLaplacianLambda() {
        return this.laplacian_lambda_;
    }

    public int getLaplacian_num_iterations() {
        return this.laplacian_num_iterations_;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }
}

