/*
 * Decompiled with CFR 0.152.
 */
package jclusteroutline;

import jclusteroutline.Geometry;

public class Vector2d
implements Comparable<Vector2d> {
    private double x;
    private double y;

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public boolean epsilonEquals(Vector2d vec) {
        return Math.abs(this.x - vec.x) < Geometry.EPSILON && Math.abs(this.y - vec.y) < Geometry.EPSILON;
    }

    public boolean lessThan(Vector2d vec) {
        return this.x < vec.x || this.x == vec.x && this.y < vec.y;
    }

    public Vector2d addC(Vector2d vec) {
        return new Vector2d(this.x + vec.x, this.y + vec.y);
    }

    public void add(Vector2d vec) {
        this.x += vec.x;
        this.y += vec.y;
    }

    public Vector2d subtractC(Vector2d vec) {
        return new Vector2d(this.x - vec.x, this.y - vec.y);
    }

    public void subtract(Vector2d vec) {
        this.x -= vec.x;
        this.y -= vec.y;
    }

    public void multiply(Vector2d factor) {
        this.x *= factor.x;
        this.y *= factor.y;
    }

    public double length() {
        return Math.hypot(this.x, this.y);
    }

    public void normalize() {
        double length = this.length();
        if (length >= Geometry.EPSILON) {
            this.x /= length;
            this.y /= length;
        }
    }

    public Vector2d normalizeClone() {
        Vector2d clone = this.clone();
        clone.normalize();
        return clone;
    }

    public Vector2d right_perpendicular() {
        return new Vector2d(this.y, -this.x);
    }

    public Vector2d left_perpendicular() {
        return new Vector2d(-this.y, this.x);
    }

    public Vector2d divideC(double scalar) {
        if (Math.abs(scalar) < Geometry.EPSILON) {
            return null;
        }
        return new Vector2d(this.x / scalar, this.y / scalar);
    }

    public void divide(double scalar) {
        if (Math.abs(scalar) >= Geometry.EPSILON) {
            this.x /= scalar;
            this.y /= scalar;
        }
    }

    public Vector2d multiplyC(double scalar) {
        return new Vector2d(this.x * scalar, this.y * scalar);
    }

    public Vector2d negate() {
        return new Vector2d(-this.x, -this.y);
    }

    public double getCoord(int orderedAxis) {
        if (orderedAxis == 0) {
            return this.x;
        }
        return this.y;
    }

    public Vector2d clone() {
        return new Vector2d(this.x, this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public int compareTo(Vector2d o) {
        if (this.lessThan(o)) {
            return -1;
        }
        return 1;
    }

    public double[] toArray() {
        double[] newArray = new double[]{this.x, this.y};
        return newArray;
    }
}

