/*
 * Decompiled with CFR 0.152.
 */
package org.horrabin.horrorss;

import org.horrabin.horrorss.RssDublinCoreModuleBean;
import org.horrabin.horrorss.RssSlashModuleBean;

public class RssItemBean {
    private String title;
    private String link;
    private String description;
    private RssDublinCoreModuleBean dcBean;
    private RssSlashModuleBean slashBean;
    private String author;
    private String pubDate;
    private String category;
    private String comments;
    private String enclosure;
    private String guid;
    private String source;
    private int TYPE_RDF = 0;
    private int TYPE_RSS = 1;
    private int rssType;

    public RssItemBean(int rssType) {
        this.title = "";
        this.link = "";
        this.description = "";
        this.rssType = rssType;
        this.author = "";
        this.category = "";
        this.pubDate = "";
        this.comments = "";
        this.enclosure = "";
        this.guid = "";
        this.source = "";
        this.dcBean = new RssDublinCoreModuleBean();
        this.slashBean = new RssSlashModuleBean();
    }

    public RssItemBean(String title, String link, String description, int rssType) {
        this.title = title;
        this.link = link;
        this.description = description;
        this.rssType = rssType;
        this.author = "";
        this.category = "";
        this.pubDate = "";
        this.comments = "";
        this.enclosure = "";
        this.guid = "";
        this.source = "";
        this.dcBean = new RssDublinCoreModuleBean();
        this.slashBean = new RssSlashModuleBean();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDublinCoreModule(RssDublinCoreModuleBean dcBean) {
        this.dcBean = dcBean;
    }

    public void setSlashModule(RssSlashModuleBean slashBean) {
        this.slashBean = slashBean;
    }

    public void setAuthor(String author) {
        if (this.rssType == this.TYPE_RSS) {
            this.author = author;
        } else {
            this.dcBean.setCreator(author);
        }
    }

    public void setPubDate(String pubDate) {
        if (this.rssType == this.TYPE_RSS) {
            this.pubDate = pubDate;
        } else {
            this.dcBean.setDate(pubDate);
        }
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public String getDescription() {
        return this.description;
    }

    public RssDublinCoreModuleBean getDublinCoreModule() {
        return this.dcBean;
    }

    public RssSlashModuleBean getSlashModule() {
        return this.slashBean;
    }

    public String getAuthor() {
        if (this.rssType == this.TYPE_RSS) {
            return this.author;
        }
        return this.dcBean.getCreator();
    }

    public String getPubDate() {
        if (this.rssType == this.TYPE_RSS) {
            return this.pubDate;
        }
        return this.dcBean.getDate();
    }

    public String getCategory() {
        return this.category;
    }

    public String getComments() {
        return this.comments;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getSource() {
        return this.source;
    }
}

