/*
 * Decompiled with CFR 0.152.
 */
package mdsj;

import java.text.DecimalFormat;
import java.util.Arrays;
import mdsj.ClassicalScaling;
import mdsj.Data;
import mdsj.IO;
import mdsj.StressMinimization;

public class MDSJ {
    private int accuracy = 5;
    private int dimensions = 2;
    private int exponent = 0;
    private boolean quiet = false;
    private int rounds = 0;
    private int stresschange = 0;
    private int timeout = 0;
    private String infile;
    private String outfile;

    public static double[][] classicalScaling(double[][] d, int dim) {
        int n = d[0].length;
        double[][] dist = new double[d.length][d[0].length];
        int i = 0;
        while (i < d.length) {
            int j = 0;
            while (j < d[0].length) {
                dist[i][j] = d[i][j];
                ++j;
            }
            ++i;
        }
        double[][] result = new double[dim][n];
        Data.randomize(result);
        ClassicalScaling.lmds(dist, result);
        return result;
    }

    public static double[][] classicalScaling(double[][] d) {
        return MDSJ.classicalScaling(d, 2);
    }

    public static double[][] stressMinimization(double[][] d, int dim) {
        double[][] x = MDSJ.classicalScaling(d, dim);
        StressMinimization sm = new StressMinimization(d, x);
        sm.iterate(0, 0, 5);
        return x;
    }

    public static double[][] stressMinimization(double[][] d, double[][] w, int dim) {
        double[][] x = MDSJ.classicalScaling(d, dim);
        StressMinimization sm = new StressMinimization(d, x, w);
        sm.iterate(0, 0, 3);
        return x;
    }

    public static double[][] stressMinimization(double[][] d) {
        return MDSJ.stressMinimization(d, 2);
    }

    public static double[][] stressMinimization(double[][] d, double[][] w) {
        return MDSJ.stressMinimization(d, w, 2);
    }

    private static String align(double val) {
        String temp = new DecimalFormat("0.######").format(val);
        int b = temp.indexOf(".");
        if (b < 0) {
            b = temp.length();
        }
        int prefix = Math.max(0, 8 - b);
        int suffix = 15 - prefix - temp.length();
        return String.valueOf("                                              ".substring(0, prefix)) + temp + "                                              ".substring(0, suffix);
    }

    private void printAnalysis(double[][] distances) {
        DecimalFormat format = new DecimalFormat(" 0.######;-0.######");
        int n = distances.length;
        Data.squareEntries(distances);
        Data.doubleCenter(distances);
        Data.multiply(distances, -0.5);
        double trace = 0.0;
        int i = 0;
        while (i < n) {
            trace += distances[i][i];
            ++i;
        }
        System.out.println("  trace: " + format.format(trace));
        double[] lambda = new double[this.dimensions];
        double[][] temp = new double[this.dimensions][n];
        Data.randomize(temp);
        double a = ClassicalScaling.smallestEigenvalue(distances);
        double b = ClassicalScaling.largestEigenvalue(distances);
        System.out.println("  spectral range: [" + format.format(Math.min(a, b)) + ", " + format.format(Math.max(a, b)) + "]");
        ClassicalScaling.eigen(distances, temp, lambda);
        int i2 = 0;
        while (i2 < this.dimensions) {
            if (new Double(lambda[i2]).equals(Double.NaN)) {
                lambda[i2] = 0.0;
            }
            ++i2;
        }
        Arrays.sort(lambda);
        double[] newLambda = new double[this.dimensions];
        int i3 = 0;
        while (i3 < this.dimensions) {
            newLambda[this.dimensions - i3 - 1] = lambda[i3];
            ++i3;
        }
        lambda = newLambda;
        System.out.println("  --------------------------------------------------------------------");
        System.out.println("    dim    eigenvalue     relative (%)   cumulative (%) residual (%)  ");
        System.out.println("  --------------------------------------------------------------------");
        double cumul = 0.0;
        int i4 = 0;
        while (i4 < this.dimensions) {
            System.out.println("    " + i4 + MDSJ.align(lambda[i4]) + MDSJ.align(100.0 * lambda[i4] / trace) + MDSJ.align(100.0 * (cumul += lambda[i4]) / trace) + MDSJ.align(100.0 * (1.0 - cumul / trace)));
            ++i4;
        }
        System.out.println("  --------------------------------------------------------------------");
    }

    public MDSJ(String[] args) throws Exception {
        int z = 2;
        if (args[args.length - 1].startsWith("-")) {
            throw new Exception("parsing error, last option is not a file: \"" + args[args.length - 1] + "\"");
        }
        this.infile = args[args.length - 1];
        if (args.length > 1 && !args[args.length - 2].startsWith("-")) {
            this.outfile = args[args.length - 1];
            this.infile = args[args.length - 2];
        } else {
            z = 1;
        }
        int i = 0;
        while (i < args.length - z) {
            block19: {
                if (!args[i].startsWith("-")) {
                    throw new Exception("parsing error, options must start with a minus: \"" + args[i] + "\"");
                }
                String option = args[i].substring(1);
                if (option.startsWith("c")) {
                    this.accuracy = Integer.parseInt(option.substring(1));
                    if (this.accuracy < 0) {
                        throw new Exception("option error, accuracy must be nonnegative: " + this.accuracy);
                    }
                    break block19;
                }
                if (option.startsWith("d")) {
                    this.dimensions = Integer.parseInt(option.substring(1));
                    if (this.dimensions <= 0) {
                        throw new Exception("option error, dimensionality must be positive: " + this.dimensions);
                    }
                    break block19;
                }
                if (option.startsWith("e")) {
                    this.exponent = Integer.parseInt(option.substring(1));
                    break block19;
                }
                if (option.startsWith("q")) {
                    this.quiet = true;
                    break block19;
                }
                if (option.startsWith("r")) {
                    this.rounds = Integer.parseInt(option.substring(1));
                    if (this.rounds <= 0) {
                        throw new Exception("option error, number of rounds must be positive: " + this.rounds);
                    }
                    break block19;
                }
                if (option.startsWith("s")) {
                    this.stresschange = Integer.parseInt(option.substring(1));
                    if (this.stresschange <= 0) {
                        throw new Exception("option error, threshold must be positive: " + this.stresschange);
                    }
                    break block19;
                }
                if (option.startsWith("t")) {
                    this.timeout = Integer.parseInt(option.substring(1));
                    if (this.timeout <= 0) {
                        throw new Exception("option error, timeout (milliseconds) must be positive: " + this.timeout);
                    }
                    break block19;
                }
                throw new Exception("parsing error, unknown option: \"" + args[i] + "\"");
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("MDSJ - Multidimensional Scaling for Java v0.2  (c) 2009 University of Konstanz\n  usage: MDSJ  [options]  infile  [outfile]        see manual for more details\n  options \n   -dD   output dimensions (default: D=2)\n   -eE   use exponential weight=dissimilarity^E (default: E=0)\n   -fF   data format: -fm matrix (default), -fl list, -fo optimized list \n   -q    quiet mode, do not print analysis results\n   -rR   stress minimization for at most R rounds\n   -sS   stress minimization until relative change is below 10^(-S)\n   -tT   stress minimization for up to T milliseconds\n  example:  MDSJ  -t2000  -s4 -d3  -q  in.txt  out.txt\n  -rR -sS -tT may be used jointly (termination once any condition holds)\n  output is written to stdout when no outfile specified");
            return;
        }
        try {
            MDSJ mdsj = new MDSJ(args);
            if (!mdsj.quiet) {
                System.out.println("MDSJ - Multidimensional Scaling for Java v0.2  (c) 2009 University of Konstanz");
            }
            long time = System.nanoTime();
            if (!mdsj.quiet) {
                System.out.print("  ...reading input file... ");
            }
            double[][] D = IO.read(mdsj.infile);
            int k = D.length;
            if (!mdsj.quiet) {
                System.out.println("done (" + (System.nanoTime() - time) / 1000000L + " ms)");
                System.out.println("  read " + D[0].length + " rows, " + D.length + " columns");
            }
            if (mdsj.dimensions >= k) {
                if (!mdsj.quiet) {
                    System.out.println("Warning: " + mdsj.dimensions + " dimensions, but only " + k + " pivot(s) present, " + (mdsj.dimensions + 1) + " required");
                    System.out.println("Outputting only " + (k - 1) + " dimensions (consider using more pivots)");
                }
                mdsj.dimensions = k - 1;
            }
            if (!mdsj.quiet) {
                System.out.println("  using " + k + " pivots for " + mdsj.dimensions + " dimensions");
            }
            double[][] L = Data.landmarkMatrix(D);
            if (!mdsj.quiet) {
                mdsj.printAnalysis(L);
            }
            double[][] result = new double[mdsj.dimensions][D[0].length];
            Data.randomize(result);
            ClassicalScaling.lmds(D, result);
            if (mdsj.rounds > 0 || mdsj.stresschange > 0 || mdsj.timeout > 0) {
                StressMinimization sm = new StressMinimization(D, result, StressMinimization.weightMatrix(D, mdsj.exponent));
                if (!mdsj.quiet) {
                    System.out.println("  normalized stress = " + sm.getNormalizedStress());
                }
                String report = sm.iterate(mdsj.rounds, mdsj.stresschange, mdsj.timeout);
                if (!mdsj.quiet) {
                    System.out.println("  " + report);
                    System.out.println("  normalized stress = " + sm.getNormalizedStress());
                }
            }
            if (mdsj.outfile != null) {
                time = System.nanoTime();
                if (!mdsj.quiet) {
                    System.out.print("  ...writing output file... ");
                }
                IO.write(result, mdsj.outfile);
                if (!mdsj.quiet) {
                    System.out.println("done (" + (System.nanoTime() - time) / 1000000L + " ms)");
                    System.out.println("  wrote " + result[0].length + " rows, " + result.length + " columns");
                    return;
                }
            }
            IO.writeStandardOut(result);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

